; Copyright 2002-2009 by Autodesk, Inc. All Rights Reserved.
;
; Permission to use, copy, modify, and distribute this software
; for any purpose and without fee is hereby granted, provided that
; the above copyright notice appears in all copies and that both
; the copyright notice and the limited warranty and restricted rights
; notice below appear in all supporting documentation.
;
; AUTODESK, INC. PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
; AUTODESK, INC. SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
; MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
; DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
; UNINTERRUPTED OR ERROR FREE.
;
; Use, duplication, or disclosure by the U.S. Government is subject to
; restrictions set forth in FAR 52.227-19 (Commercial Computer
; Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
; (Rights in Technical Data and Computer Software), as applicable.

; 30-Mar-04 Lee Hollingworth/LEEH; modified for globalization
; 22-Aug-98 NEHolt created
; Note: place this file somewhere in the AcadE or ACAD path. The entry in wd.env will then
;  look like this:  WD_XCAT,wd_xcat.lsp,User's external catalog lookup routine
;

; Data is passed from AutoCAD Electrical in AutoLISP variable "wd_xcat". Its format is:
; (nth 0 wd_xcat)  =  (list  what entname symname) where
;    where "what" = "SCH" or "PNL" component being inserted/edited
; (nth 1 wd_xcat)  =  (list  mfg cat assycode cnt wdblknam)
; (nth 2 wd_xcat)  =  (list of lists of multiple part number info) [PNL only]
; (nth 3 wd_xcat)  =  (list of parallel lists of misc ATTRIBUTE name and values)
;
(princ "\n")
(princ (c:wd_msg "XCAT006" nil "AcadE --> External catalog lookup"))
(princ "\n")
(princ (strcat (c:wd_msg "XCAT007" nil "Data from AcadE") "="))
(princ wd_xcat)
(princ "\n")
(princ (c:wd_msg "FIELD005" nil "MFG"))
(princ "=")
(princ (nth 0 (nth 1 (car wd_xcat))))
(princ "\n")
(princ (c:wd_msg "FIELD282" nil "CAT"))
(princ "=")
(princ (nth 1 (nth 1 (car wd_xcat))))
(princ "\n")
(princ (strcat (c:wd_msg "XCAT008" nil "Multiple Bill of Material data lists") "=")) ; *** 19-Apr-04 PMM removed abbreviation
(setq xx (nth 2 (car wd_xcat)))
(if xx (princ xx))
(princ "\n")
(princ (strcat (c:wd_msg "XCAT009" nil "Attribute/value pairs") ":"))
(setq x 0)
(setq msg "")
(foreach xx (nth 0 (nth 3 (car wd_xcat)))
  (setq val (nth x (nth 1 (nth 3 (car wd_xcat)))))
  (if (/= val "")
      (setq msg (strcat msg xx "=" val " "))
  )
  (setq x (1+ x))
)
(if (/= msg "") (princ (strcat msg "\n")))
;
; ********** Put call to your own "parts lookup" routine here
; (startapp "notepad.exe") ; just an example!
;
; ***
; Return catalog data back to WD in this format
; (list
;   ;  ****   1st on only component data list of lists  ****
;   (list
;     (list  what "" blocknam ins_loc ins_scl ins_rot sho_dlg)
;     (list  mfg cat assycode cnt wdblknam)
;     (list  ; optional "extra" part numbers
;           (list mfg1 cat1 assycode1 cnt1 wdblknam1)
;           (list mfg2 cat2 assycode2 cnt2 wdblknam2)
;           (list mfg3 cat3 assycode3 cnt3 wdblknam3)
;           ...
;     )
;     (list                                    ; optional ATTR names/values
;           (list "DESC1" "DESC2" "DESC3" .... ) ; Attribute names
;           (list "EXIT CONVEYOR" "NO.4" "INDEX SPEED" ...) ; attr values
;     )
;   )
;   ;  ****   Optional 2nd component data list of lists  ****
;   (list
;     (list  what "" blocknam ins_loc ins_scl ins_rot sho_dlg)
;     (list  mfg cat assycode cnt wdblknam)
;     (list  ; optional "extra" part numbers
;           (list mfg1 cat1 assycode1 cnt1 wdblknam1)
;           (list mfg2 cat2 assycode2 cnt2 wdblknam2)
;           (list mfg3 cat3 assycode3 cnt3 wdblknam3)
;           ...
;     )
;     (list                                    ; optional ATTR names/values
;           (list "DESC1" "DESC2" "DESC3" .... ) ; Attribute names
;           (list "START CONVEYOR" "NO.5" "INDEX SPEED" ...) ; attr values
;     )
;   )
;   ;  ****   Optional 3rd-->nth component data list of lists  ****
;   (list ...
;      ....
;   )
; )
;
; "what" = "SCH" for schematic, "PNL" for panel footprints
; "blocknam" = (optional) block name to insert or swap (if editing existing)
; "sho_dlg" = 1 to pop up INS/EDIT dialog after swap, edit, or insert
;
; If inserting new block:
;   "ins_loc" = nil for user pick point; "x,y" for specific XY coordinate;
;             "@x,y" to insert at offset from previous insert
;   "ins_scl" = nil for insert at default scale; <value>=insert at scale value
;   "ins_rot" = nil for insert at angle 0.0; <value>=insert at rot value
;
; Call (c:wd_rtrn_2wd <data list>) to pass data back to AcadE
;(c:wd_rtrn_2wd rtrn) ; return list of catalog data back to AcadE
